//===================================================================
//   Linux Kernel Ver2.2 / Ver2.4
//-------------------------------------------------------------------
//   sample / sample.c  ver1.0.041021
//===================================================================
#include <stdio.h>

#include "I7sIo.h"


int main(void)
{
	unsigned int i;
	int    fd;
	int    ret;
	int bdno;//ܡֹ
	WORD wDat;
	DWORD dwDat;
	double volt;//A/DD/AŰ
	int	ch=0;//ǤϤ٤ƣͥΤߤλѤǤ
	IB7_PARAINFO  Ib7ParaInfo;
	IB7_PARAAD    Ib7ParaAd;
	IB7_PARADA    Ib7ParaDa;
	IB7_PARAENC   Ib7ParaEnc;
	IB7_PARAPIO   Ib7ParaPio;


	////////	Open	/////////////////////////////////////////////
	//ѥܡɤξ
	bdno=0;
	//ʣΥܡɤѤϣ(ݣˤΥܡֹOpen롣
	if ( 0 > (fd=I7fOpen(bdno)) ) {
		fprintf(stderr, "Can not open /dev/hrpib70. fd=%i\n", fd);
		return -1;
	}
	printf("Open hrpib7%d ok. fd=%d\n",bdno, fd);


	////////	Reset	/////////////////////////////////////////////
    ret = I7fReset(bdno);//D/A,PIOͥνϤ򣰤ˤ
    printf("Device Reset ret = %i\n", ret);


	////////	GetDeviceInformation	/////////////////////////////
    Ib7ParaInfo.Ib7no = bdno; 
    ret = I7fGetInfo(&Ib7ParaInfo);//ܡɤξIDϥꥢNoβ4
    printf("Get Device Infomation\nret = %i, ib7no=%i, ioBase=%08X.\n",
            ret,
            Ib7ParaInfo.DevInfo.ib7no,
            Ib7ParaInfo.DevInfo.ioBase);
    printf("IB7 version = %04X, IB7 ID=%i.\n\n",
            Ib7ParaInfo.DevInfo.Ib7Ver,
            Ib7ParaInfo.DevInfo.Ib7ID);
    
    printf("init ok.  press ENTER to continue...\n");
    getchar();
    //----------------------------------------------------------------


	////////	A/D Sample	/////////////////////////////////////////////
	printf("A/D Sample--------------------------------------\n");
	Ib7ParaAd.Ib7no = bdno;
	Ib7ParaAd.ChData.ch = ch;

	if ( (ret=I7fAdRead(&Ib7ParaAd)) < 0 ) {
		printf("AD Read Error. ret=%i\n", ret);
		ret = -1;
	}
	
	wDat=Ib7ParaAd.ChData.wData[0];
	volt=20.0*(double)wDat/4096.0-10.0;//ǡݡŰ͡ʡޣϥ󥸡
	//volt=5.0*wDat/4096.0;//ǡݡŰ͡ʣϥ󥸡
	printf("A/D Read (%dch) = %2.3f[V] / %04X\n\n", ch, volt, wDat );


	////////	D/A Sample	/////////////////////////////////////////////
	printf("D/A Sample--------------------------------------\n");
	Ib7ParaDa.Ib7no = bdno;
	Ib7ParaDa.ChData.ch = ch;
	
	volt=5.0;//֤
	wDat=(WORD)(volt*4096.0/20.0+2047.5);//Ű͡ݡǡʡޣֽϥ󥸡
	Ib7ParaDa.ChData.wData[0] = wDat;

	if ( (ret=I7fDaWrite(&Ib7ParaDa)) < 0 ) {
		printf("D/A WRITE Error. ret=%i\n", ret);
		ret = -1;
	}
	printf("D/A Write (%dch) = %2.3f[V] / %04X\n\n", ch, volt, wDat );


	////////	ENC	   /////////////////////////////////////////////////
	printf("ENC Sample--------------------------------------\n");
	Ib7ParaEnc.Ib7no = bdno;
	Ib7ParaEnc.ChData.ch = ch;

	Ib7ParaEnc.ChData.mode = ENC_MODE_PULSE;//Up/Downѥ륹⡼
	if ((ret=I7fEncMode(&Ib7ParaEnc))<0) {//⡼
		printf("ENC MODE Error.\n");
		ret = -1;
	}
	printf("ENC Mode UP/DOWN(%dch)\n", ch);

	if ((ret=I7fEncStart(&Ib7ParaEnc))<0) {//ȳ
		printf("ENC START Error.\n");
		ret = -1;
 	}
	printf("ENC Start OK.\n");

	dwDat=0x123456;
	printf("ENC Write (%dch) = %d / %08X\n", ch, dwDat, dwDat);
	Ib7ParaEnc.ChData.dwData[0] = dwDat;
	ret = I7fEncWrite(&Ib7ParaEnc);//Ƚ
	
	if ((ret=I7fEncRead(&Ib7ParaEnc))<0) {//ɤ߽Ф
		printf("ENC READ Error.\n");
		ret = -1;
 	}
 	dwDat=Ib7ParaEnc.ChData.dwData[0];
	printf("ENC Read (%dch) = %d / %08X\n", ch, dwDat, dwDat);

	if((ret=I7fEncStop(&Ib7ParaEnc)) < 0){//
		printf("I7f ENC STOP Error. ret=%i\n", ret);
		return -1;
	}
	printf("ENC Stop OK.\n");

	if((ret=I7fEncClear(&Ib7ParaEnc)) < 0){//ȥꥢ
		printf("I7f ENC Clear Error. ret=%i\n", ret);
		return -1;
	}
	printf("ENC Clear OK.\n");	
    
	if ((ret=I7fEncRead(&Ib7ParaEnc))<0) {//ɤ߽Ф
		printf("ENC READ Error.\n");
		ret = -1;
 	}
 	dwDat=Ib7ParaEnc.ChData.dwData[0];
	printf("ENC Read (%dch) = %d / %08X\n\n", ch, dwDat, dwDat);


	////////	PIO	/////////////////////////////////////////////
	printf("PIO Sample--------------------------------------\n");
	Ib7ParaPio.Ib7no = bdno;
 	Ib7ParaPio.ChData.OutGroup = ch;//Ǥchϥݡȡ롼ףΣ
	Ib7ParaPio.ChData.InGroup = ch;//Ǥchϥݡȡ롼ףΣ
	
	wDat = 0xabcd;
	Ib7ParaPio.ChData.wData = wDat;
	ret = I7fPioWrite(&Ib7ParaPio);//ꤷ롼פΣbitǡ񤭽Ф
    if (ret < 0) {
        printf("PIO WRITE Error.\n");
        ret = -1;
    }
	printf("PIO Write (PortGroup No.%d) = %04X\n", ch, wDat);

	ret = I7fPioRead(&Ib7ParaPio);//ꤷ롼פΣbitǡɤ߽Ф
	if (ret < 0) {
		printf("PIO READ Error.\n");
		ret = -1;
	}
	wDat=Ib7ParaPio.ChData.wData;
	printf("PIO Read  (PortGroup No.%d) = %04X\n", ch, wDat);

	printf("Pio Set Rest (PortGroup No.%d) = AAAA\n", ch);
	for(i=0;i<16;i++){//SETRESET롣
		if(i&1){
			Ib7ParaPio.ChData.ch=i;
			I7fPioSet(&Ib7ParaPio);
		}
		else{
			Ib7ParaPio.ChData.ch=i;
			I7fPioReset(&Ib7ParaPio);
		}
	}

	ret = I7fPioRead(&Ib7ParaPio);//ꤷ롼פΣbitǡɤ߽Ф
 	if (ret < 0) {
		printf("PIO READ Error.\n");
        ret = -1;
    }
	wDat=Ib7ParaPio.ChData.wData;
	printf("PIO Read  (PortGroup No.%d) = %04X\n\n", ch, wDat);


    ////////    Close    /////////////////////////////////////////////
    if (0 > (ret=I7fClose(bdno)) ) {
        fprintf(stderr, "Can not close file. ret=%i\n", ret);
        return -2;
    }


    printf("sample end.\n");
    return 0;
}
