//===================================================================
//   Linux Kernel Ver2.2 / Ver2.4
//-------------------------------------------------------------------
//   LIB / I7sIo.c
//===================================================================

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "I7sIo.h"

// global variant
static int      fdIb7   [MAX_IB7_NUM] = {-1, -1, -1, -1};
static DWORD    Ib7Data [MAX_IB7_NUM] = { 0,  0,  0,  0};



//===================================================================
//   I7fOpen
//===================================================================
int I7fOpen(int Ib7No)
{
    char    devname[1024];
    int     fd = -1;
    if ( (uint)Ib7No >= MAX_IB7_NUM )     return RTN_IBOVER;

    sprintf(devname, "/dev/%s%d", IB7_DEVNAME, Ib7No);
    fd=open(devname,  0);

    if (fd>=0)   fdIb7[Ib7No] = fd;
    return fd;
}

//===================================================================
//   I7fClose
//===================================================================
int I7fClose(int Ib7No)
{
 int    ret;

    if ( (uint)Ib7No >= MAX_IB7_NUM ) return RTN_IBOVER;
    if (fdIb7[Ib7No]<0)               return RTN_IBNOPEN;

    if ((ret=close(fdIb7[Ib7No])) < 0 ) {
        fprintf(stderr, "Can not close file. ret=%i\n", ret);
        return RTN_IBNOCLOSE;
    }
    fdIb7[Ib7No] = -1;
    return RTN_IBOK;
}

//===================================================================
//   I7fReset
//===================================================================
int I7fReset(int Ib7No)
{
    if ( (uint)Ib7No >= MAX_IB7_NUM )    return RTN_IBOVER;

    Ib7Data[Ib7No] = 0;
    return ioctl(fdIb7[Ib7No], IOCTL_IB7_RESET);
}


//===================================================================
//   I7fGetInfo
//-------------------------------------------------------------------
//   Para1 = WORD          Ib7no;        // Ib7 # (0 to Max(=3))
//   Para2 = IB7_DEV_INFO  DevInfo;      // Parameter
//===================================================================
int I7fGetInfo(PIB7_PARAINFO Ib7ParaInfo)
{
    if ( (uint)Ib7ParaInfo->Ib7no >= MAX_IB7_NUM )    return RTN_IBOVER;
    if ( !Ib7ParaInfo )                               return RTN_IBNOPARA;
    return ioctl( fdIb7[Ib7ParaInfo->Ib7no],
                  IOCTL_IB7_GET_INFO,
                 &Ib7ParaInfo->DevInfo  );
}


//===================================================================
//   I7fAdRead
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_ADDACH  ChData;          // data
//         ---------------------
//    Para2-1 = WORD   ch;                 // Channel  (0 to 15)
//    Para2-2 = WORD  wData[2];          // Parameter
//                    wData[0]=Read data // Parameter
//===================================================================
int I7fAdRead(PIB7_PARAAD Ib7ParaAd)
{
 int    ret;

    if ( (uint)Ib7ParaAd->Ib7no >= MAX_IB7_NUM )    return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaAd->Ib7no]<0)                  return RTN_IBNOPEN; // No Open

    if ((ret=ioctl( fdIb7[Ib7ParaAd->Ib7no],
                    IOCTL_IB7_AD_READ,
                   &Ib7ParaAd->ChData          ) ) >= 0) {
        Ib7Data[Ib7ParaAd->Ib7no] = Ib7ParaAd->ChData.wData[0];

    }
    return(ret);
}

//===================================================================
//   I7fDaWrite
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_ADDACH  ChData;          // data
//         ---------------------
//    Para2-1 = WORD   ch;                  // Channel  (-1, 0 to 15)
//    Para2-2 = WORD   wData[2];           // Parameter
//                     wData[0]=Write data // Parameter
//===================================================================
int I7fDaWrite(PIB7_PARADA Ib7ParaDa)
{
 int    ret;

    if ( (uint)Ib7ParaDa->Ib7no >= MAX_IB7_NUM )    return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaDa->Ib7no]<0)                  return RTN_IBNOPEN; // No Open

    if ((ret=ioctl( fdIb7[Ib7ParaDa->Ib7no],
                    IOCTL_IB7_DA_WRITE,
                   &Ib7ParaDa->ChData       )) >= 0 ) {
        Ib7Data[Ib7ParaDa->Ib7no] = Ib7ParaDa->ChData.wData[0];
    }
    return(ret);
}

//===================================================================
//   I7fDataCheck
//-------------------------------------------------------------------
//   Para1 = WORD    Ib7no;            // Ib7 # (0 to Max(=3))
//   Para2 = DWORD   dwData[2];         // Parameter(I/O Addr.)
//===================================================================
inline int I7fDataCheck(PIB7_PARA Ib7Para)
{
    if ( (uint)Ib7Para->Ib7no >= MAX_IB7_NUM )    return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7Para->Ib7no]<0)                  return RTN_IBNOPEN; // No Open

    Ib7Para->dwData[0] = Ib7Data[Ib7Para->Ib7no];
    return RTN_IBOK;
}


//===================================================================
//   I7fEncMode
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_ENCCH   ChData;          // data
//         ---------------------
//    Para2-1 = int      ch;              // Channel  (0 to 15)
//    Para2-2 = WORD     command;         // Command
//    Para2-3 = WORD     mode;            // Mode
//    Para2-4 = WORD     status;          // Status
//    Para2-5 = DWORD    dwData[2];       // Parameter
//         ---------------------
//    Mode = ENC_MODE_PULSE / ENC_MODE_X1 / ENC_MODE_X2 / ENC_MODE_X4
//===================================================================
int I7fEncMode(PIB7_PARAENC Ib7ParaEnc)
{
 int    ret;

    if ( (uint)Ib7ParaEnc->Ib7no >= MAX_IB7_NUM )    return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaEnc->Ib7no]<0)                  return RTN_IBNOPEN; // No Open

    if ( Ib7ParaEnc->ChData.ch < 0  ||
         Ib7ParaEnc->ChData.ch >= IB7_MAXENCCH )     return RTN_IBCHOVER; // ch over

    switch(Ib7ParaEnc->ChData.mode) {
      case ENC_MODE_PULSE:
      case ENC_MODE_X1:
      case ENC_MODE_X2:
      case ENC_MODE_X4:  break;
      default:           return RTN_ENCNOMODE; // no Mode
    }

    if ((ret=ioctl( fdIb7[Ib7ParaEnc->Ib7no],
                    IOCTL_IB7_ENC_MODE,
                   &Ib7ParaEnc->ChData       )) >= 0 ) {
//      Ib7Data[Ib7ParaEnc->Ib7no] = Ib7ParaEnc->ChData.dwData[0];

    }
    return(ret);
}

//===================================================================
//   I7fEncStart
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_ENCCH   ChData;          // data
//         ---------------------
//    Para2-1 = int      ch;              // Channel  (0 to 7)
//    Para2-2 = WORD     command;         // Command
//    Para2-3 = WORD     mode;            // Mode
//    Para2-4 = WORD     status;          // Status
//    Para2-5 = DWORD    dwData[2];       // Parameter
//         ---------------------
//    Mode = ENC_MODE_PULSE / ENC_MODE_X1 / ENC_MODE_X2 / ENC_MODE_X4
//===================================================================
int I7fEncStart(PIB7_PARAENC Ib7ParaEnc)
{
 int    ret;

    if ( (uint)Ib7ParaEnc->Ib7no >= MAX_IB7_NUM )    return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaEnc->Ib7no]<0)                  return RTN_IBNOPEN; // No Open

    if (Ib7ParaEnc->ChData.ch < 0  ||
        Ib7ParaEnc->ChData.ch >= IB7_MAXENCCH    )   return RTN_IBCHOVER; // ch over

    if ((ret=ioctl( fdIb7[Ib7ParaEnc->Ib7no],
                    IOCTL_IB7_ENC_START,
                   &Ib7ParaEnc->ChData       )) >= 0 ) {
//      Ib7Data[Ib7ParaEnc->Ib7no] = Ib7ParaEnc->ChData.dwData[0];

    }
    return(ret);
}

//===================================================================
//   I7fEncRead
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_ENCCH   ChData;          // data
//         ---------------------
//    Para2-1 = int      ch;              // Channel  (0 to 7)
//    Para2-2 = WORD     command;         // Command
//    Para2-3 = WORD     mode;            // Mode
//    Para2-4 = WORD     status;          // Status
//    Para2-5 = DWORD    dwData[2];       // Parameter
//         ---------------------
//    Mode = ENC_MODE_PULSE / ENC_MODE_X1 / ENC_MODE_X2 / ENC_MODE_X4
//===================================================================
int I7fEncRead(PIB7_PARAENC Ib7ParaEnc)
{
 int    ret;

    if ( (uint)Ib7ParaEnc->Ib7no >= MAX_IB7_NUM )    return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaEnc->Ib7no]<0)                  return RTN_IBNOPEN; // No Open

    if (Ib7ParaEnc->ChData.ch < 0  ||
        Ib7ParaEnc->ChData.ch >= IB7_MAXENCCH    )   return RTN_IBCHOVER; // ch over

    if ((ret=ioctl( fdIb7[Ib7ParaEnc->Ib7no],
                    IOCTL_IB7_ENC_READ,
                   &Ib7ParaEnc->ChData       )) >= 0 ) {
        Ib7Data[Ib7ParaEnc->Ib7no] = Ib7ParaEnc->ChData.dwData[0];

    }
    return(ret);
}

//===================================================================
//   I7fEncWrite
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_ENCCH   ChData;          // data
//         ---------------------
//    Para2-1 = int      ch;              // Channel  (0 to 7)
//    Para2-2 = WORD     command;         // Command
//    Para2-3 = WORD     mode;            // Mode
//    Para2-4 = WORD     status;          // Status
//    Para2-5 = DWORD    dwData[2];       // Parameter
//         ---------------------
//    Mode = ENC_MODE_PULSE / ENC_MODE_X1 / ENC_MODE_X2 / ENC_MODE_X4
//===================================================================
int I7fEncWrite(PIB7_PARAENC Ib7ParaEnc)
{
 int    ret;

    if ( (uint)Ib7ParaEnc->Ib7no >= MAX_IB7_NUM )    return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaEnc->Ib7no]<0)                  return RTN_IBNOPEN; // No Open

    if (Ib7ParaEnc->ChData.ch < 0  ||
        Ib7ParaEnc->ChData.ch >= IB7_MAXENCCH    )   return RTN_IBCHOVER; // ch over

    if ((ret=ioctl( fdIb7[Ib7ParaEnc->Ib7no],
                    IOCTL_IB7_ENC_WRITE,
                   &Ib7ParaEnc->ChData       )) >= 0 ) {
        Ib7Data[Ib7ParaEnc->Ib7no] = Ib7ParaEnc->ChData.dwData[0];

    }
    return(ret);
}

//===================================================================
//   I7fEncStop
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_ENCCH   ChData;          // data
//         ---------------------
//    Para2-1 = int      ch;              // Channel  (0 to 7)
//    Para2-2 = WORD     command;         // Command
//    Para2-3 = WORD     mode;            // Mode
//    Para2-4 = WORD     status;          // Status
//    Para2-5 = DWORD    dwData[2];       // Parameter
//         ---------------------
//    Mode = ENC_MODE_PULSE / ENC_MODE_X1 / ENC_MODE_X2 / ENC_MODE_X4
//===================================================================
int I7fEncStop(PIB7_PARAENC Ib7ParaEnc)
{
 int    ret;

    if ( (uint)Ib7ParaEnc->Ib7no >= MAX_IB7_NUM )    return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaEnc->Ib7no]<0)                  return RTN_IBNOPEN; // No Open

    if (Ib7ParaEnc->ChData.ch < 0  ||
        Ib7ParaEnc->ChData.ch >= IB7_MAXENCCH    )   return RTN_IBCHOVER; // ch over

    if ((ret=ioctl( fdIb7[Ib7ParaEnc->Ib7no],
                    IOCTL_IB7_ENC_STOP,
                   &Ib7ParaEnc->ChData       )) >= 0 ) {
//      Ib7Data[Ib7ParaEnc->Ib7no] = Ib7ParaEnc->ChData.dwData[0];

    }
    return(ret);
}

//===================================================================
//   I7fEncClear
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_ENCCH   ChData;          // data
//         ---------------------
//    Para2-1 = int      ch;              // Channel  (0 to 7)
//    Para2-2 = WORD     command;         // Command
//    Para2-3 = WORD     mode;            // Mode
//    Para2-4 = WORD     status;          // Status
//    Para2-5 = DWORD    dwData[2];       // Parameter
//         ---------------------
//    Mode = ENC_MODE_PULSE / ENC_MODE_X1 / ENC_MODE_X2 / ENC_MODE_X4
//===================================================================
int I7fEncClear(PIB7_PARAENC Ib7ParaEnc)
{
 int    ret;

    if ( (uint)Ib7ParaEnc->Ib7no >= MAX_IB7_NUM )    return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaEnc->Ib7no]<0)                  return RTN_IBNOPEN; // No Open

    if (Ib7ParaEnc->ChData.ch < 0  ||
        Ib7ParaEnc->ChData.ch >= IB7_MAXENCCH    )   return RTN_IBCHOVER; // ch over

    if ((ret=ioctl( fdIb7[Ib7ParaEnc->Ib7no],
                    IOCTL_IB7_ENC_CLEAR,
                   &Ib7ParaEnc->ChData       )) >= 0 ) {
//       Ib7Data[Ib7ParaEnc->Ib7no] = Ib7ParaEnc->ChData.dwData[0];

    }
    return(ret);
}



//===================================================================
//   I7fPioWrite
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_PIOCH   ChData;          // data
//         ---------------------
//    Para2-1 = int      InGroup;         // In  Group (0 to 3)
//    Para2-2 = int      OutGroup;        // Out Group (0 to 3, -1)
//    Para2-3 = WORD     ch;              // Channel   (0 to 15)
//    Para2-4 = WORD     wData;           // Parameter
//===================================================================
int I7fPioWrite(PIB7_PARAPIO Ib7ParaPio)
{
 int    ret;

    if ( (uint)Ib7ParaPio->Ib7no >= MAX_IB7_NUM )      return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaPio->Ib7no]<0)                    return RTN_IBNOPEN; // No Open

    if (Ib7ParaPio->ChData.OutGroup != -1 ) {
       if ( Ib7ParaPio->ChData.OutGroup < 0    ||
            Ib7ParaPio->ChData.OutGroup >= IB7_MAXPIOOUTGRP ) return RTN_IBCHOVER; // Out ch over
    }
    if ((ret=ioctl( fdIb7[Ib7ParaPio->Ib7no],
                    IOCTL_IB7_PIO_WRITE,
                   &Ib7ParaPio->ChData       )) >= 0 ) {
        Ib7Data[Ib7ParaPio->Ib7no] = Ib7ParaPio->ChData.wData;

    }
    return(ret);
}

//===================================================================
//   I7fPioRead
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_PIOCH   ChData;          // data
//         ---------------------
//    Para2-1 = int      InGroup;         // In  Group (0 to 3)
//    Para2-2 = int      OutGroup;        // Out Group (0 to 3, -1)
//    Para2-3 = WORD     ch;              // Channel   (0 to 15)
//    Para2-4 = WORD     wData;           // Parameter
//===================================================================
int I7fPioRead(PIB7_PARAPIO Ib7ParaPio)
{
 int    ret;

    if ( (uint)Ib7ParaPio->Ib7no >= MAX_IB7_NUM )      return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaPio->Ib7no]<0)                    return RTN_IBNOPEN; // No Open

    if (Ib7ParaPio->ChData.InGroup < 0  ||
        Ib7ParaPio->ChData.InGroup >= IB7_MAXPIOINGRP ) return RTN_IBCHOVER; // Out ch over

    if ((ret=ioctl( fdIb7[Ib7ParaPio->Ib7no],
                    IOCTL_IB7_PIO_READ,
                   &Ib7ParaPio->ChData       )) >= 0 ) {
        Ib7Data[Ib7ParaPio->Ib7no] = Ib7ParaPio->ChData.wData;

    }
    return(ret);
}

//===================================================================
//   I7fPioSet
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_PIOCH   ChData;          // data
//         ---------------------
//    Para2-1 = int      InGroup;         // In  Group (0 to 3)
//    Para2-2 = int      OutGroup;        // Out Group (0 to 3, -1)
//    Para2-3 = WORD     ch;              // Channel   (0 to 15)
//    Para2-4 = WORD     wData;           // Parameter
//===================================================================
int I7fPioSet(PIB7_PARAPIO Ib7ParaPio)
{
 int    ret;

    if ( (uint)Ib7ParaPio->Ib7no >= MAX_IB7_NUM )      return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaPio->Ib7no]<0)                    return RTN_IBNOPEN; // No Open

    if (Ib7ParaPio->ChData.OutGroup != -1 ) {
       if ( Ib7ParaPio->ChData.OutGroup >= IB7_MAXPIOINGRP ) return RTN_IBCHOVER; // Out ch over
    }
    if ( Ib7ParaPio->ChData.ch >= IB7_PIO_OUTCHPERGRP ) return RTN_IBCHOVER; // Out ch over

    if ((ret=ioctl( fdIb7[Ib7ParaPio->Ib7no],
                    IOCTL_IB7_PIO_SET,
                   &Ib7ParaPio->ChData       )) >= 0 ) {
//     Ib7Data[Ib7ParaPio->Ib7no] = Ib7ParaPio->ChData.dwData[0];

    }
    return(ret);
}
//===================================================================
//   I7fPioReSet
//-------------------------------------------------------------------
//   Para1 = WORD        Ib7no;           // Ib7 # (0 to Max(=3))
//   Para2 = IB7_PIOCH   ChData;          // data
//         ---------------------
//    Para2-1 = int      InGroup;         // In  Group (0 to 3)
//    Para2-2 = int      OutGroup;        // Out Group (0 to 3, -1)
//    Para2-3 = WORD     ch;              // Channel   (0 to 15)
//    Para2-4 = WORD     wData;           // Parameter
//===================================================================
int I7fPioReset(PIB7_PARAPIO Ib7ParaPio)
{
 int    ret;

    if ( (uint)Ib7ParaPio->Ib7no >= MAX_IB7_NUM )      return RTN_IBOVER;  // No IB7#
    if (fdIb7[Ib7ParaPio->Ib7no]<0)                    return RTN_IBNOPEN; // No Open

    if (Ib7ParaPio->ChData.OutGroup != -1 ) {
       if ( Ib7ParaPio->ChData.OutGroup >= IB7_MAXPIOINGRP ) return RTN_IBCHOVER; // Out ch over
    }
    if ( Ib7ParaPio->ChData.ch >= IB7_PIO_OUTCHPERGRP ) return RTN_IBCHOVER; // Out ch over

    if ((ret=ioctl( fdIb7[Ib7ParaPio->Ib7no],
                    IOCTL_IB7_PIO_RESET,
                   &Ib7ParaPio->ChData       )) >= 0 ) {
//     Ib7Data[Ib7ParaPio->Ib7no] = Ib7ParaPio->ChData.dwData[0];

    }
    return(ret);
}






