//===================================================================
//   Linux Kernel Ver2.4 / Ver2.6
//-------------------------------------------------------------------
//  I7sPciBase.h
//===================================================================
#ifndef __IB7_PCIBASE_H__
#define __IB7_PCIBASE_H__

//------ Device Version ---------------------------------------------
#define   IB7_HARDWARE_VERSION    0x0100

//------ Vender ID & SubVender ID -----------------------------------
#define  IB7_VENDORID           0x136c
#define  IB7_DEVICEID           0xa0a0
#define  IB7_SUBVENDORID        0x136c

//------ Device Name (I7sModule.c) ----------------------------------
#define  IB7_MAJOR      99
#define  IB7_DEVNAME    "hrpib7"
#define  IB7_MAGIC      'x'

#define  MAX_IB7_NUM    4

//------ IRQ --------------------------------------------------------
#define   MIN_IB7_IRQ      3
#define   MAX_IB7_IRQ    127

//-------------------------------------------------------------------
#define  IB7_LCR_SIZE        16
#define  IB7_IO_SIZE        256

//-------------------------------------------------------------------

typedef unsigned int      DWORD;
typedef unsigned short    WORD;
typedef unsigned char     BYTE;
typedef int               BOOL;

#define FALSE            0
#define TRUE             1

//-------------------------------------------------------------------
//  IOCTL Macro
//-------------------------------------------------------------------
#define IOCTL_IB7_RESET             _IO  (IB7_MAGIC, 0)
#define IOCTL_IB7_GET_INFO          _IOR (IB7_MAGIC, 1, PIB7_DEV_INFO)

#define IOCTL_IB7_AD_READ           _IOWR(IB7_MAGIC, 2, DWORD*)
#define IOCTL_IB7_DA_WRITE          _IOWR(IB7_MAGIC, 3, DWORD*)
#define IOCTL_IB7_ENC_MODE          _IOWR(IB7_MAGIC, 4, DWORD*)
#define IOCTL_IB7_ENC_START         _IOWR(IB7_MAGIC, 5, DWORD*)
#define IOCTL_IB7_ENC_STOP          _IOWR(IB7_MAGIC, 6, DWORD*)
#define IOCTL_IB7_ENC_READ          _IOWR(IB7_MAGIC, 7, DWORD*)
#define IOCTL_IB7_ENC_WRITE         _IOWR(IB7_MAGIC, 8, DWORD*)
#define IOCTL_IB7_ENC_CLEAR         _IOWR(IB7_MAGIC, 9, DWORD*)
#define IOCTL_IB7_PIO_WRITE         _IOWR(IB7_MAGIC, 12, DWORD*)
#define IOCTL_IB7_PIO_READ          _IOWR(IB7_MAGIC, 13, DWORD*)
#define IOCTL_IB7_PIO_SET           _IOWR(IB7_MAGIC, 14, DWORD*)
#define IOCTL_IB7_PIO_RESET         _IOWR(IB7_MAGIC, 15, DWORD*)

//---------------------------------------------------------------------------
//  IB7 Device Information
//---------------------------------------------------------------------------
typedef struct _IB7_DEVINFO
{
    WORD    ib7no;              // Ib7 num 0-3
    WORD    irq;                // irq num
    WORD    Ib7Ver;             // Ib7 pci ver
    WORD    Ib7ID;              // Ib7 serial num (SubSystemID)
    DWORD   ioBase;             // base io address
    DWORD   ioLCR;              // base Apic LocalConfigurationRegister
} IB7_DEV_INFO, *PIB7_DEV_INFO; // 16bytes

typedef struct _IB7_DEV
{
    BYTE    ib7no;              // Ib7 num 0-3
    BYTE    irq;                // irq num
    WORD    Revision;           // Ib7 pci ver
    WORD    VendorID;           // 136c
    WORD    DeviceID;           // a0a0
    WORD    SubVenID;           // 136c
    WORD    SubSysID;           // Ib7 serial num (SubSystemID)
    DWORD   ioBase;             // base io address
    DWORD   ioLCR;              // base Apic LocalConfigurationRegister
    DWORD   dwIb7DevMask;       // each bit
} IB7_DEV, *PIB7_DEV;           // 24bytes


//====== APCI21 =================================================
#define  MAX_APIC21_EXT_INT      4

#define  APIC_STATUS     0x00
#define  APIC_LCR        0x04
#define  APIC_VREG_ADDR  0x08
#define  APIC_VREG_DATA  0x0C
#define  APCI21_ADDR     IB7_BASELCR[i]+APIC_VREG_ADDR
#define  APCI21_DATA     IB7_BASELCR[i]+APIC_VREG_DATA



//----------------------------------------
//  APIC LCR(Local Configuration Register)
//----------------------------------------
#define  APIC_LCR_ACR1               0x00
#define  APIC_LCR_ASR1               0x01
#define  APIC_LCR_IFR1               0x02
#define  APIC_LCR_ICR1               0x03
#define  APIC_LCR_LCR4               0x04


//---------------------------------------------------------------------------
//  IB7 Calling Parameter (I7fReadVersion/I7fReadIOAddr/)
//---------------------------------------------------------------------------
typedef struct _IB7_PARA
{
    WORD        Ib7no;             // Ib7 # (0 to Max(=3))
    DWORD       dwData[2];         // Parameter
} IB7_PARA, *PIB7_PARA;

//---------------------------------------------------------------------------
//  IB7 Calling Parameter (I7fGetInfo)
//---------------------------------------------------------------------------
typedef struct _IB7_PARAINFO
{
    WORD          Ib7no;        // Ib7 # (0 to Max(=3))
    IB7_DEV_INFO  DevInfo;      // Parameter
} IB7_PARAINFO, *PIB7_PARAINFO;

//---------------------------------------------------------------------------
//  IB7 Calling Parameter (I7fAdRead/I7fDaWrite/I7fDaChkWrite)
//---------------------------------------------------------------------------
typedef struct _IB7_ADDACH
{
    int         ch;                // Channel  (0 to 15)
    WORD        wData[2];          // Parameter
} IB7_ADDACH, *PIB7_DADDACH;
//---------------------------------// Parameter A/D
typedef struct _IB7_PARAAD
{
    WORD        Ib7no;             // Ib7 # (0 to Max(=3))
    IB7_ADDACH  ChData;            // Channel  (0 to 15)
} IB7_PARAAD, *PIB7_PARAAD;
//---------------------------------// Parameter D/A
typedef struct _IB7_PARADA
{
    WORD        Ib7no;             // Ib7 # (0 to Max(=3))
    IB7_ADDACH  ChData;            // Channel  (0 to 15)
} IB7_PARADA, *PIB7_PARADA;

//---------------------------------------------------------------------------
//  IB7 Calling Parameter (I7fEncxxxx)
//---------------------------------------------------------------------------
typedef struct _IB7_ENCCH
{
    int         ch;                // Channel  (-1, 0 to 15)
    WORD        command;           // Command
    WORD        mode;              // mode
    WORD        status;            // Status
    DWORD       dwData[2];         // Parameter
} IB7_ENCCH, *PIB7_ENCCH;

//---------------------------------// Parameter ENC
typedef struct _IB7_PARAENC
{
    WORD        Ib7no;             // Ib7 # (0 to Max(=3))
    IB7_ENCCH   ChData;            // Channel  (0 to 15)
} IB7_PARAENC, *PIB7_PARAENC;

//---------------------------------------------------------------------------
//  IB7 Calling Parameter (I7fPioxxxx)
//---------------------------------------------------------------------------
typedef struct _IB7_PIOCH
{
    int         InGroup;           // In  Groupe (0 to 3)
    int         OutGroup;          // Out Groupe (0 to 3, -1)
    WORD        ch;                // Channel    (0 to 7)
    WORD        wData;             // Parameter
} IB7_PIOCH, *PIB7_PIOCH;

//---------------------------------// Parameter PIO
typedef struct _IB7_PARAPIO
{
    WORD        Ib7no;             // Ib7 # (0 to Max(=3))
    IB7_PIOCH   ChData;            // Channel data
} IB7_PARAPIO, *PIB7_PARAPIO;


//---------------------------------------------------------------------------
#define  IB7_MAXADCH          16     // Max A/D Chennel 
#define  IB7_MAXDACH          16     // Max D/A Channel
#define  IB7_MAXENCCH         16     // Max ENC Channel
#define  IB7_PIO_OUTCHPERGRP  16     // PIO Group
#define  IB7_MAXPIOINGRP       1     // Max PIO In  Group
#define  IB7_MAXPIOOUTGRP      1     // Max PIO Out Group
#define  IB7_MAXPIOCH         16     // Max PIO Channel

enum   { ENC_MODE_PULSE,
         ENC_MODE_X1,
         ENC_MODE_X2,
         ENC_MODE_X4,
};


//---------------------------------------------------------------------------
//  Function Return Code
//---------------------------------------------------------------------------
#define  RTN_IBOK          0    // OK
#define  RTN_IBOVER       -1    // No I/F Board Over
#define  RTN_IBNOPEN      -2    // No Open  I/F board
#define  RTN_IBNOCLOSE    -3    // No Close I/F board
#define  RTN_IBNOPARA     -4    // No Parameter
#define  RTN_IBCHOVER     -5    // No I/F Board Channel Over
#define  RTN_ENCNOMODE    -6    // No ENC Mode
#define  RTN_IBOPENED     -7    // Opened  I/F board
#define  RTN_IBIOCTL      -8    // IOCTL error.
#define  RTN_IBTMOVER     -9    // Time over.


#endif    //__IB7_PCIBASE_H__
