#ifndef __I7SFUNC_H__
#define __I7SFUNC_H__

#include <asm/io.h>

#include "I7sPciBase.h"

#define DECLARE_IB7_BASEADR WORD IB7_BASEADDR[MAX_IB7_NUM] = {0,0,0,0}

//===================================================================
//  Basic I/O Function
//===================================================================
inline  BYTE  _in_byte(WORD Addr);
inline  WORD  _in_word(WORD Addr);
inline  DWORD _in_dword(WORD Addr);
inline  void  _out_byte(WORD Addr, BYTE Data);
inline  void  _out_word(WORD Addr, WORD Data);
inline  void  _out_dword(WORD Addr, DWORD Data);

//-------------------------------------------------------
WORD   Ad_Read(WORD,WORD);
void   Da_Write(WORD,WORD,WORD);
WORD   Enc_AddrSet(WORD IbNo,WORD ch,WORD Offset);
void   Enc_CounterEnable(WORD Ib7No, WORD ch, WORD bitSet);
void   Enc_SetCounterMode(WORD Ib7No, WORD ch, WORD EncMode);
DWORD  Enc_ReadCounter(WORD Ib7No, WORD ch);
void   Enc_WriteCounter(WORD Ib7No, WORD ch, DWORD WtData);

//-------------------------------------------------------
WORD   PIO_AddrSet(WORD IbNo,WORD pio,WORD Offset);
void   Pio_ModeSet(WORD Ib7No);
WORD   Pio_ReadGrp(WORD Ib7No, WORD RdGroup);
void   Pio_WriteGrp(WORD Ib7No, WORD WtGroup, WORD WtData);
void   Pio_BitSet(WORD Ib7No, WORD StGroup, WORD ch, WORD bitSet);
#endif
