//===================================================================
//   Linux Kernel Ver2.4 / Ver2.6
//-------------------------------------------------------------------
//  I7sFunc.c
//-------------------------------------------------------------------
//===================================================================
//WORD  Ad_Read(WORD Ib7No, WORD ch);
//void  Da_Write(WORD Ib7No, WORD ch, WORD OutData);

//WORD   Enc_AddrSet(WORD IbNo,WORD ch,WORD Offset);
//void   Enc_CounterEnable(WORD Ib7No, WORD ch, WORD bitSet);
//void   Enc_SetCounterMode(WORD Ib7No, WORD ch, WORD EncMode);
//DWORD  Enc_ReadCounter(WORD Ib7No, WORD ch);
//void   Enc_WriteCounter(WORD Ib7No, WORD ch, DWORD WtData);

//WORD   PIO_AddrSet(WORD IbNo,WORD pio,WORD Offset);
//void   Pio_ModeSet(WORD Ib7No);
//WORD   Pio_ReadGrp(WORD Ib7No, WORD RdGroup);
//void   Pio_WriteGrp(WORD Ib7No, WORD WtGroup, WORD WtData);
//void   Pio_BitSet(WORD Ib7No, WORD StGroup, WORD ch, WORD bitSet);

//------------------------------------------------------------------
#include "I7sFunc.h"

extern WORD IB7_BASEADDR[MAX_IB7_NUM];

//-------------------------------------------------------------------
#define  IB7_AD_TIMEOUT    2000     // Time out
#define  AD_START          0x04

#define  AD1_DATA(i)       (IB7_BASEADDR[i]+0x00) //<-0x00
#define  AD2_DATA(i)       (IB7_BASEADDR[i]+0x10) //<-0x10
#define  AD1_EOC(i)        (_in_word(IB7_BASEADDR[i]+0x90) & 0x01)
#define  AD2_EOC(i)        (_in_word(IB7_BASEADDR[i]+0x90) & 0x02)

//-------------------------------------------------------------------
#define  DA_START(i)       _out_word(IB7_BASEADDR[i]+0x92, 0)
#define  DA1_CH1(i)        (IB7_BASEADDR[i]+0x20) //0x20 IOCS -2 Offset
#define  DA2_CH1(i)        (IB7_BASEADDR[i]+0x30) //0x30 IOCS -3 Offset
#define  HW_DA_MIN         (-4096)
#define  DA_MIN            (-2048)

//-------------------------------------------------------------------
WORD  ENC_OFFSET[] = { 0x40, 0x48, 0x50, 0x58, 0xE0, 0xE8, 0xF0, 0xF8};
#define  ENC_IC_ADDR(iNo, ch)    (IB7_BASEADDR[iNo] + ENC_OFFSET[ch>>1])
enum   { ENC_COMAND,        // 0
         ENC_DATAH,         // 1
         ENC_DATAM,         // 2
         ENC_DATAL,         // 3
};

//-------------------------------------------------------------------
#define  PIO_IC1           0x60
#define  PIO_IC2           0xc0

enum   { PIO_PORT1,         // 0
         PIO_PORT2,         // 1
         PIO_PORT3,         // 2
         PIO_PORT4,         // 3
         PIO_PORT5,         // 4
         PIO_PORT6,         // 5
         PIO_PORT7,         // 6
         PIO_PORT8,         // 7
         PIO_PORT9,         // 8
         PIO_CR0,           // 9
         PIO_CR1,           // 10
         PIO_CR2,           // 11
         PIO_CR3,           // 12
};

enum   { PIO_NO1, PIO_NO2 };

//===================================================================
//  Basic I/O Function
//===================================================================
inline  BYTE  _in_byte(WORD Addr) { return((BYTE)inb(Addr)); }
inline  WORD  _in_word(WORD Addr) { return((WORD)inw(Addr)); }
inline  DWORD _in_dword(WORD Addr) { return((DWORD)inl(Addr)); }
inline  void  _out_byte(WORD Addr, BYTE Data) { outb(Data, Addr); }
inline  void  _out_word(WORD Addr, WORD Data) { outw(Data, Addr); }
inline  void  _out_dword(WORD Addr, DWORD Data) { outl(Data, Addr); }

//===================================================================
//  Ad_Read
//===================================================================
WORD  Ad_Read(WORD Ib7No, WORD ch)
{
 int  iTime;

    iTime = IB7_AD_TIMEOUT;
    if ( ch<8 ) {
        _out_word(AD1_DATA(Ib7No), (ch<<3)|AD_START);
       while(iTime>0) {
           iTime--;
           if (AD1_EOC(Ib7No)) return( _in_word(AD1_DATA(Ib7No)) & 0x0FFF );
       }
    } else {
        _out_word(AD2_DATA(Ib7No), ((ch&7)<<3)|AD_START);
       while(iTime>0) {
           iTime--;
           if (AD2_EOC(Ib7No)) return( _in_word(AD2_DATA(Ib7No)) & 0x0FFF );
       }
    }
    return -1;
}

//===================================================================
//   Da_Write
//-------------------------------------------------------------------
//  Ib7No : 0 to 3
//  ch    : 0 to 15
//  data  : 0 to 4095 (12bits)
//===================================================================
void  Da_Write(WORD Ib7No, WORD ch, WORD OutData)
{
 WORD  oDat;
 int   iCnt;

    oDat = (OutData*(HW_DA_MIN/DA_MIN))&0x1fff;

    if (ch>=IB7_MAXDACH) {
        for (iCnt=0; iCnt<IB7_MAXDACH; iCnt++)   Da_Write(Ib7No, iCnt, oDat);

    } else {
        if (ch<8)  _out_word(DA1_CH1(Ib7No)+( ch<<1),    oDat);
           else    _out_word(DA2_CH1(Ib7No)+((ch&7)<<1), oDat);
    }
    DA_START(Ib7No);
}


//===================================================================
//  Enc Address Check
//===================================================================
WORD  Enc_AddrSet(WORD IbNo,WORD ch,WORD Offset)
{
    return(ENC_IC_ADDR(IbNo, ch) + ((Offset<<1)&6) );
}

//===================================================================
//   Enc_CounterEnable/Desable
//===================================================================
void  Enc_CounterEnable(WORD Ib7No, WORD ch, WORD bitSet)
{
 WORD  EncSetAddr, bSetC;
 const WORD bSetDat[] = { 0x14, 0x1c, 0x15, 0x1d };

    if (bitSet&1) bSetC = 0;    // Enable  A,B count
        else      bSetC = 2;    // Desable A,B count

    if (ch!=0xFF) {
//      bSetC += (ch&1);
        ch &= 0x0f;
//      if (ch>7) bSetC++;
        if (ch&1) bSetC++;      // B ?
        EncSetAddr = Enc_AddrSet(Ib7No, ch, ENC_COMAND);
        _out_word( EncSetAddr, bSetDat[bSetC] );
    } else {
        for (ch=0; ch<8; ch++) {
            EncSetAddr = Enc_AddrSet(Ib7No, ch, ENC_COMAND);
            _out_word(EncSetAddr, bSetDat[bSetC  ]);
            _out_word(EncSetAddr, bSetDat[bSetC+1]);
        }
    }
}

//===================================================================
//   Enc_SetCounterMode
//===================================================================
void  Enc_SetCounterMode(WORD Ib7No, WORD ch, WORD EncMode)
{
 WORD  EncSetAddr, bSetC;
 const WORD bSetDat[] = { 0x10, 0x18, 0x11, 0x19, 0x12, 0x1a, 0x13, 0x1b };

    bSetC = EncMode<<1;

    if (ch!=0xFF) {
//      bSetC += (ch&1);
        ch    &= 0x0F;
//      if (ch>7) bSetC++;
        if (ch&1) bSetC++;         // B ?
        EncSetAddr = Enc_AddrSet(Ib7No, ch, ENC_COMAND);
        _out_word( EncSetAddr, bSetDat[bSetC] );
    } else {
        for (ch=0; ch<8; ch++) {
            EncSetAddr = Enc_AddrSet(Ib7No, ch, ENC_COMAND);
            _out_word(EncSetAddr, bSetDat[bSetC  ]);        // A Count mode
            _out_word(EncSetAddr, bSetDat[bSetC+1]);        // B Count mode
        }
    }
}

//===================================================================
//   Enc_ReadCounter
//===================================================================
DWORD  Enc_ReadCounter(WORD Ib7No, WORD ch)
{
 WORD    EncSetAddr, bSetV;
 DWORD   RdData;
 const WORD  bSetDat[] = { 0x04, 0x06 };


    if ( ch >= IB7_MAXENCCH)   return 0;

    if (ch&1) bSetV = bSetDat[1];    // 1(B)
       else   bSetV = bSetDat[0];    // 0(A)

    EncSetAddr = Enc_AddrSet(Ib7No, ch, ENC_COMAND);

    _out_word(EncSetAddr, bSetV );

    RdData = ((_in_word(EncSetAddr+(ENC_DATAH<<1))&0x00FF)<<16) |
             ((_in_word(EncSetAddr+(ENC_DATAM<<1))&0x00FF)<<8)  |
              (_in_word(EncSetAddr+(ENC_DATAL<<1))&0x00FF);
    return RdData;

}


//===================================================================
//   Enc_WriteCounter
//===================================================================
void  Enc_WriteCounter(WORD Ib7No, WORD ch, DWORD WtData)
{
 WORD    EncSetAddr, bSetV;
 const WORD bSetDat[] = { 0x00, 0x02 };

    if ( ch >= IB7_MAXENCCH)   return;

    if (ch&1) bSetV = bSetDat[1];    // 1(B)
       else   bSetV = bSetDat[0];    // 0(A)

    EncSetAddr = Enc_AddrSet(Ib7No, ch, ENC_COMAND);

    _out_byte(EncSetAddr+(ENC_DATAH<<1), (BYTE)(WtData>>16));  //  High
    _out_byte(EncSetAddr+(ENC_DATAM<<1), (BYTE)(WtData>>8 ));  //  Middle
    _out_byte(EncSetAddr+(ENC_DATAL<<1), (BYTE)(WtData    ));  //  Low
    _out_byte(EncSetAddr, bSetV );                             //  Send
}

//===================================================================



//===================================================================
//  PIO Address Check
//===================================================================
WORD  PIO_AddrSet(WORD IbNo,WORD pio,WORD Offset)
{
 const WORD VBaseAddr[] = { PIO_IC1, PIO_IC2 };

    return(IB7_BASEADDR[IbNo] + VBaseAddr[pio&1] + ((Offset<<1)&14) );
}



//===================================================================
//   Pio_ModeSet
//===================================================================
void  Pio_ModeSet(WORD Ib7No)
{
const BYTE  pioSetData[] = { 0x00, 0xff, 0xfd, 0xed };
 WORD  SetAddr1, SetAddr2;

    SetAddr1 =  PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT1 );
    SetAddr2 =  PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT1 );

    _out_byte(SetAddr1+(PIO_CR0<<1), pioSetData[0] );
    _out_byte(SetAddr2+(PIO_CR0<<1), pioSetData[0] );
    _out_byte(SetAddr1+(PIO_CR1<<1), pioSetData[1] );
    _out_byte(SetAddr2+(PIO_CR1<<1), pioSetData[1] );
    _out_byte(SetAddr1+(PIO_CR2<<1), pioSetData[2] );
    _out_byte(SetAddr2+(PIO_CR2<<1), pioSetData[2] );
    _out_byte(SetAddr1+(PIO_CR3<<1), pioSetData[3] );
    _out_byte(SetAddr2+(PIO_CR3<<1), pioSetData[3] );

    _out_byte(SetAddr1+(PIO_PORT6<<1), 0 );
    _out_byte(SetAddr2+(PIO_PORT6<<1), 0 );
    _out_byte(SetAddr1+(PIO_PORT7<<1), 0 );
    _out_byte(SetAddr2+(PIO_PORT7<<1), 0 );
    _out_byte(SetAddr1+(PIO_PORT8<<1), 0 );
    _out_byte(SetAddr2+(PIO_PORT8<<1), 0 );
    _out_byte(SetAddr1+(PIO_PORT9<<1), 0 );
    _out_byte(SetAddr2+(PIO_PORT9<<1), 0 );

}

//===================================================================
//   Pio_ReadGrp
//===================================================================
WORD  Pio_ReadGrp(WORD Ib7No, WORD RdGroup)
{
    switch(RdGroup) {
     case 0: //---- Port1-2, Port1-1 ( BP4, BP3 )--------------
            return (WORD)( (_in_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT2))<<8) |
                           (_in_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT1))&0x00FF) );
     case 1: //---- Port1-4, Port1-3 ( BP2, BP1 )--------------
            return (WORD)( (_in_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT4))<<8) |
                           (_in_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT3))&0x00FF) );
     case 2: //---- Port2-2, Port2-1 ( BP4, BP3 )--------------
            return (WORD)( (_in_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT2))<<8) |
                           (_in_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT1))&0x00FF) );
     case 3: //---- Port2-4, Port2-3 ( BP2, BP1 )--------------
            return (WORD)( (_in_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT4))<<8) |
                           (_in_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT3))&0x00FF) );
     default: //--- default -----------------------------------
            return 0;
    }

}

//===================================================================
//   Pio_WriteGrp
//===================================================================
void  Pio_WriteGrp(WORD Ib7No, WORD WtGroup, WORD WtData)
{
    switch(WtGroup)
    {
     case 0: //---- BP6, BP7 -------------------------
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT6), WtData&0x00FF);
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT7), WtData>>8);
            return;
     case 1: //---- BP8, BP9 -------------------------
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT8), WtData&0x00FF);
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT9), WtData>>8);
            return;
     case 2: //---- BP6, BP7 -------------------------
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT6), WtData&0x00FF);
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT7), WtData>>8);
        return;
     case 3: //---- BP8, BP9 -------------------------
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT8), WtData&0x00FF);
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT9), WtData>>8);
            return;
     case (WORD)-1:    // 4 Groups
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT6), WtData&0x00FF);
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT7), WtData>>8);
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT8), WtData&0x00FF);
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO1, PIO_PORT9), WtData>>8);

            _out_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT6), WtData&0x00FF);
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT7), WtData>>8);
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT8), WtData&0x00FF);
            _out_byte(PIO_AddrSet(Ib7No, PIO_NO2, PIO_PORT9), WtData>>8);
            return;
    }
}


//===================================================================
//   Pio_BitSet
//===================================================================
void  Pio_BitSet(WORD Ib7No, WORD StGroup, WORD ch, WORD bitSet)
{
 WORD  SetAddr, SetV, SetGrpNo, SetPort;
 WORD  RdData,  BitMask;
 const WORD  CSetOff[] = { PIO_PORT6, PIO_PORT7, PIO_PORT8, PIO_PORT9 };

    if (bitSet&1) SetV = 0xffff;
       else       SetV = 0;

    if (StGroup==(WORD)-1)  {
        Pio_WriteGrp(Ib7No, StGroup, SetV );
        return;
    }

    switch(StGroup) {
      case 0:  SetPort = 0; SetGrpNo = PIO_NO1; break;
      case 1:  SetPort = 2; SetGrpNo = PIO_NO1; break;
      case 2:  SetPort = 0; SetGrpNo = PIO_NO2; break;
      case 3:  SetPort = 2; SetGrpNo = PIO_NO2; break;
      default: return;
    }
    if (ch>7)  SetPort++;
    SetAddr =  PIO_AddrSet(Ib7No, SetGrpNo, CSetOff[SetPort] );
    RdData  = _in_byte(SetAddr);

    BitMask = 1<<(ch&7);

    if (bitSet) {
        if (!(RdData&BitMask)) _out_byte(SetAddr, RdData | BitMask);
    } else {
        if (RdData&BitMask)    _out_byte(SetAddr, RdData&(~BitMask));
    }
}
